#ifndef _RANKING_SONY_H
#define _RANKING_SONY_H

#include "UnityNP.h"
#include "Mutex.h"
#include <string>
#include <vector>

#define MAX_GAMEINFO_SIZE SCE_NP_SCORE_GAMEINFO_SIZE

namespace UnityPlugin
{
	// struct is used for marshaling data to the managed side
	struct Rank
	{
		const char* onlineID;
		int	PcId;
		int	serialRank;
		int	rank;
		int	highestRank;
		bool hasGameData;
		UInt64 score;
		UInt64 recordDate;
		const char* comment;
		int gameInfoSize;
		const UInt8* gameInfoData;
		int boardId;
		bool provisional;
	};

	PRX_EXPORT bool PrxRankingGetLastError(ResultCode* result);

	PRX_EXPORT ErrorCode PrxRankingRegisterCache(int boardLineCount, int writeLineCount, bool friendCache, int rangeLineCount);
	PRX_EXPORT bool PrxRankingRegisterScoreIsBusy();
	PRX_EXPORT ErrorCode PrxRankingRegisterScore(int boardID, Int64 score, const char* comment);
	PRX_EXPORT ErrorCode PrxRankingRegisterScoreWithData(int boardID, Int64 score, const char* comment, const char* data, int datalen);

	PRX_EXPORT bool PrxRankingRefreshOwnRankIsBusy();
	PRX_EXPORT ErrorCode PrxRankingRefreshOwnRank(int boardID);
	PRX_EXPORT ErrorCode PrxRankingGetOwnRank(Rank* rank);

	PRX_EXPORT bool PrxRankingRefreshFriendRankIsBusy();
	PRX_EXPORT ErrorCode PrxRankingRefreshFriendRank(int boardID);
	PRX_EXPORT void PrxRankingLockFriendRankList();
	PRX_EXPORT void PrxRankingUnlockFriendRankList();
	PRX_EXPORT int PrxRankingGetFriendRankCount();
	PRX_EXPORT ErrorCode PrxRankingGetFriendRank(int index, Rank* rank);

	PRX_EXPORT bool PrxRankingRefreshRankListIsBusy();
	PRX_EXPORT ErrorCode PrxRankingRefreshRankList(int boardID, int firstIndex, int count);
	PRX_EXPORT void PrxRankingLockRankList();
	PRX_EXPORT void PrxRankingUnlockRankList();
	PRX_EXPORT int PrxRankingGetRankListCount();
	PRX_EXPORT ErrorCode PrxRankingGetRank(int index, Rank* rank);
	PRX_EXPORT int PrxRankingGetTotalRankCount();

	struct CachedRank
	{
		CachedRank()
		{
			clear();
		}

		~CachedRank()
		{
		}

		void clear()
		{
			comment = "";
			memset(&NpId, 0, sizeof(SceNpId));
			PcId = 0;
			serialRank = 0;
			rank = 0;
			highestRank = 0;
			hasGameData = 0;
			score = 0;
			gameInfoSize = 0;
			//		comment = "";
			boardId = 0;
			provisional = false;
		}

		std::string				comment;
		SceNpId					NpId;
		SceNpScorePcId			PcId;
		SceNpScoreRankNumber	serialRank;
		SceNpScoreRankNumber	rank;
		SceNpScoreRankNumber	highestRank;
		SceInt32				hasGameData;
		SceNpScoreValue			score;
		SceSize					gameInfoSize;
		//	std::string				comment;
		UInt8					gameInfoData[MAX_GAMEINFO_SIZE];
		SceNpScoreBoardId		boardId;
		bool					provisional;
	};

	class CachedRanking
	{
	private:
		SimpleLock m_Lock;
		ResultCode m_LastResult;

		bool m_RefreshRangeScoreBusy;
		bool m_RefreshFriendRankBusy;
		bool m_RegisterScoreBusy;
		bool m_RefreshOwnRankBusy;
		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::RankInformation> m_FutureRangeScore;
		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::FriendsRankInformation> m_FutureFriendRank;
		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::UserRankInformation> m_FutureOwnRank;
		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::TempRank> m_FutureTempRank;

		CachedRank m_OwnRank[MAX_NUM_USERS_SIGNED_IN];

		std::vector<CachedRank*> m_FriendRanks;
		std::vector<CachedRank*> m_Ranks;
		int m_TotalScoreCount;
		SceNpScoreBoardId m_RefreshOwnBoardID;
		CachedRank m_NewRank;
		
	public:
		CachedRanking();
		~CachedRanking() {};

		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }

		bool ProcessEvent(const sce::Toolkit::NP::Event& event);

		bool RegisterScoreIsBusy();
		bool RefreshOwnRankIsBusy();
		bool RefreshFriendRankIsBusy();
		void LockFriendsRankList();
		void UnlockFreindsRankList();
		int GetFriendsRankCount();
		bool RefreshRankListIsBusy();
		void LockRankList();
		void UnlockRankList();
		int GetRankListCount();
		int GetTotalRankCount();

		ErrorCode RegisterCache(int boardLineCount, int writeLineCount, bool friendCache, int rangeLineCount);
		ErrorCode RegisterScore(int boardID, Int64 score, const char* comment, const char *attacheddata, int attacheddatalength);
		ErrorCode RefreshOwnRank(int boardID);
		ErrorCode RefreshFriendRank(int boardID);
		ErrorCode RefreshRankList(int boardID, int firstIndex, int count);
		ErrorCode GetRank(unsigned int index, Rank* rank);
		ErrorCode GetOwnRank(Rank* rank);
		ErrorCode GetFriendRank(unsigned int index, Rank* rank);

	protected:
		void ClearFriendRankList();
		void ClearRankList();
	};

	extern CachedRanking gRanking;
}

#endif // _RANKING_SONY_H
